# Pow(x, n)
<p>实现 <a href="https://www.cplusplus.com/reference/valarray/pow/" target="_blank">pow(<em>x</em>, <em>n</em>)</a> ，即计算 x 的 n 次幂函数（即，x<sup><span style="font-size:10.8333px">n</span></sup>）。</p><p> </p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>x = 2.00000, n = 10<strong><br />输出：</strong>1024.00000</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>x = 2.10000, n = 3<strong><br />输出：</strong>9.26100</pre><p><strong>示例 3：</strong></p><pre><strong>输入：</strong>x = 2.00000, n = -2<strong><br />输出：</strong>0.25000<strong><br />解释：</strong>2<sup>-2</sup> = 1/2<sup>2</sup> = 1/4 = 0.25</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>-100.0 < x < 100.0</code></li>	<li><code>-2<sup>31</sup> <= n <= 2<sup>31</sup>-1</code></li>	<li><code>-10<sup>4</sup> <= x<sup>n</sup> <= 10<sup>4</sup></code></li></ul>
<p>以下错误的选项是？</p>
## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    double x = 2.00000;
    int n = 10;
    double res;

    res = sol.myPow(x, n);

    cout << fixed << setprecision(5) << res;
    return 0;
}
```

## 答案
```cpp
class Solution
{
public:
    double myPow(double x, int n)
    {
        if (n == 0)
            return 1.0;
        unsigned long long u = llabs(n);
        double ans = 1.0;
        while (u)
        {
            if (u & 1)
                ans *= x;
            x *= x;
            u >>= 1;
        }
        return n > 0 ? 1.0 / ans : ans;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    double myPow(double x, int n)
    {
        if (n == INT_MIN)
        {
            double t = dfs(x, -(n / 2));
            return 1 / t * 1 / t;
        }
        else
        {
            return n < 0 ? 1 / dfs(x, -n) : dfs(x, n);
        }
    }

private:
    double dfs(double x, int n)
    {
        if (n == 0)
        {
            return 1;
        }
        else if (n == 1)
        {
            return x;
        }
        else
        {
            double t = dfs(x, n / 2);
            return (n % 2) ? (x * t * t) : (t * t);
        }
    }
};
```

### B
```cpp
class Solution
{
public:
    double myPow(double x, int n)
    {
        if (n == 0)
            return 1;
        if (n % 2 == 1)
        {
            double temp = myPow(x, n / 2);
            return temp * temp * x;
        }
        else if (n % 2 == -1)
        {
            double temp = myPow(x, n / 2);
            return temp * temp / x;
        }
        else

        {
            double temp = myPow(x, n / 2);
            return temp * temp;
        }
    }
};

```

### C
```cpp
class Solution
{
public:
    double helper(double x, int n)
    {
        if (n == 0)
            return 1.0;
        double y = helper(x, n / 2);
        return n % 2 == 0 ? y * y : y * y * x;
    }

    double myPow(double x, int n)
    {
        long long N = static_cast<long long>(n);
        if (N == 0)
            return 1;
        return N > 0 ? helper(x, N) : 1. / helper(x, -N);
    }
};
```
